<?php

namespace App\Employer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'company';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User', 'id');
    }

    public function posts()
    {
        return $this->hasMany('App/Employer\Post', 'company_id');
    }

}